-- huge thanks to FlipFlopBell for this 3D Skybox template, modified by Bear64DX.

if unsupported then return end

specialHolidays = {
    [HOLIDAY_EVENT_HALLOWEEN] = true,
    [HOLIDAY_EVENT_CHRISTMAS] = true,
    [HOLIDAY_EVENT_ST_PATRICKS] = true,
    [HOLIDAY_EVENT_EASTER] = true,
    [HOLIDAY_EVENT_ANNIVERSARY] = true
}

E_MODEL_SKYBOX = smlua_model_util_get_id("skybox_geo")

local l = gLakituState

function bhv_skybox_init(o)
    o.oFlags = OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE
    o.header.gfx.skipInViewCheck = true
    obj_scale(o, 10.0)
end

function bhv_skybox_loop(o)
    o.oPosX = l.pos.x
    o.oPosY = l.pos.y
    o.oPosZ = l.pos.z
end

id_bhv3DSkybox = hook_behavior(nil, OBJ_LIST_LEVEL, false, bhv_skybox_init, bhv_skybox_loop)

local function spawn_skybox(o)
    --local skyboxCheck = obj_get_nearest_object_with_behavior_id(o, id_bhv3DSkybox)
    local skyboxCheck = nil
    if specialHolidays[holidayEvent] and holidayEvent ~= HOLIDAY_EVENT_NEW_YEARS_EVE then return end

    if skyboxCheck == nil then
        if not specialHolidays[holidayEvent] and gLevels[gGlobalSyncTable.level].skybox ~= nil and (holidayEvent ~= HOLIDAY_EVENT_NEW_YEARS_EVE and gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE) or holidayEvent == HOLIDAY_EVENT_NEW_YEARS_EVE or (gLobbies[gGlobalSyncTable.lobby].skybox ~= nil and gGlobalSyncTable.roundState ~= ROUND_STATE_ACTIVE) then
            spawn_non_sync_object(id_bhv3DSkybox, E_MODEL_SKYBOX, l.pos.x, l.pos.y, l.pos.z, function (o)
                    o.oAnimState = holidayEvent == HOLIDAY_EVENT_NEW_YEARS_EVE and 0 or gLevels[gGlobalSyncTable.level].skybox or gLobbies[gGlobalSyncTable.lobby].skybox
                end
            )
        end
    end
end

-- Nighttime Levels
local function mario_update()
    if holidayEvent == HOLIDAY_EVENT_NEW_YEARS_EVE or gLevels[gGlobalSyncTable.level].skybox == SKYBOX_NIGHT or gNetworkPlayers[0].currLevelNum == LEVEL_SNS then
        set_lighting_dir(2, 300)
        set_lighting_color(1, 400)
        set_lighting_color(0, 400)
        if holidayEvent == HOLIDAY_EVENT_NEW_YEARS_EVE then return end
    end

    if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE and gLevels[gGlobalSyncTable.level].skybox == SKYBOX_NIGHT or gNetworkPlayers[0].currLevelNum == LEVEL_SNS then
        if not specialHolidays[holidayEvent] then
            set_lighting_dir(2, 300)
            set_lighting_color(1, 400)
            set_lighting_color(0, 400)
        end
    else
        set_lighting_dir(2, 0)
        set_lighting_color(1, 500)
        set_lighting_color(0, 500)
    end
end

hook_event(HOOK_MARIO_UPDATE, mario_update)
hook_event(HOOK_ON_LEVEL_INIT, spawn_skybox)